﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VIMT.VIAEMRService;
using VIMT.VIAEMRService.Messages;
using VIMT.VIASchedulingService.Messages;
using VA.TMP.Integration.VIMT.Vista.Mappers;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment
{
    public class SendBothLoginsToEcStep : FilterBase<MakeAppointmentStateObject>
    {
        public override void Execute(MakeAppointmentStateObject state)
        {
            if (!string.IsNullOrEmpty(state.VistaFakeResponseType))
            {
                state.ProEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = "FAKE_ProviderLogin";
                state.PatEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = "FAKE_PatientLogin";
                return;
            }
            LoginRequest patLogin = new LoginRequest
            {
                side = Side.Patient,
                Request = state.PatLoginRequest
            };
            LoginRequest proLogin = new LoginRequest
            {
                side = Side.Provider,
                Request = state.ProLoginRequest
            };
            Parallel.ForEach(new LoginRequest[] { patLogin, proLogin }, login => 
            {
                login.userId = VistaMapperHelper.GetViaLoginId(login.Request, login.side);
            });
            state.ProEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = proLogin.userId;
            state.PatEcRequest.VIMTVIASchdMakeApptReqqueryBeanInfo.VIMTVIASchdMakeApptReqproviderInfo.mcs_userId = patLogin.userId;
        }

        //private string GetLoginId(VIMTVIAScheLIloginVIARequest request, Side side)
        //{
        //    Logger.Instance.Debug(string.Format("Calling LoginVIA EC for {0} Side", side.ToString()));
        //    var loginResponse = request.SendReceive<VIMTVIAScheLIloginVIAResponse>(MessageProcessType.Local);
        //    Logger.Instance.Debug(string.Format("Exiting LoginVIA EC for {0} Side", side.ToString()));

        //    if (loginResponse == null)
        //        throw new Exception(string.Format("VIA Login failed for {0} Site, no response was returned", side.ToString()));
        //    if (loginResponse.ExceptionOccured || loginResponse.VIMTVIAScheLIuserTOInfo == null)
        //        throw new Exception(string.Format("VIA Login Failed for {0} Site. Error: {1}.  Full Message: {2}", side.ToString(), loginResponse.ExceptionMessage, loginResponse.VIMTVIAScheLIuserTOInfo?.VIMTVIAScheLIfault2Info?.mcs_message));
        //    if (string.IsNullOrEmpty(loginResponse.VIMTVIAScheLIuserTOInfo.mcs_DUZ))
        //        throw new Exception(string.Format("No User Id was returned from the Login Request for the {0} Site", side.ToString()));
        //    return loginResponse.VIMTVIAScheLIuserTOInfo.mcs_DUZ;
        //}
    }

    public class LoginRequest
    {
        public LoginRequest() { }

        public Side side { get; set; }

        public VIMTVIAScheLIloginVIARequest Request { get; set; }

        public string userId { get; set; }
    }
}
